/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class WorldTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.world.World"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        List<String> brightness = Arrays.asList("checkLightFor", "func_180500_c", "getLightFromNeighborsFor", "func_175671_l", "getLightFromNeighbors", "func_175705_a", "getRawLight", "func_175638_a", "getLight", "func_175699_k", "func_175721_c");
        for (MethodNode methodNode : classNode.methods) {
            String methodName = this.mapMethodName(classNode, methodNode);
            if (brightness.contains(methodName)) {
                methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.setLightLevel());
            }
            block12 : switch (methodName) {
                case "getHorizon": 
                case "func_72919_O": {
                    methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.setSkyHeight());
                    break;
                }
                case "updateEntityWithOptionalForce": 
                case "func_72866_a": {
                    for (AbstractInsnNode node : methodNode.instructions) {
                        if (node.getOpcode() == 182) {
                            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
                            if (!methodInsnNode.name.equals("getPersistentChunks")) continue;
                            AbstractInsnNode prevNode = node.getPrevious();
                            methodNode.instructions.insertBefore(prevNode, (AbstractInsnNode)new VarInsnNode(25, 0));
                            methodNode.instructions.insertBefore(prevNode, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", "field_72995_K", "Z"));
                            methodNode.instructions.insertBefore(prevNode, (AbstractInsnNode)new InsnNode(4));
                            methodNode.instructions.insertBefore(prevNode, (AbstractInsnNode)new InsnNode(130));
                            continue;
                        }
                        if (node.getOpcode() != 54 || ((VarInsnNode)node).var != 5) continue;
                        methodNode.instructions.insertBefore(node, (AbstractInsnNode)new InsnNode(126));
                        break block12;
                    }
                    break;
                }
                case "updateEntities": 
                case "func_72939_s": {
                    for (AbstractInsnNode next : methodNode.instructions) {
                        if (!(next instanceof LdcInsnNode) || !((LdcInsnNode)next).cst.equals("blockEntities")) continue;
                        methodNode.instructions.insertBefore(next.getNext().getNext(), this.removeTileEntities());
                        break block12;
                    }
                    break;
                }
                case "getSkyColor": 
                case "func_72833_a": {
                    methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.getFasterSkyColor());
                    break;
                }
                case "func_72945_a": 
                case "getCollidingBoundingBoxes": {
                    for (AbstractInsnNode next : methodNode.instructions) {
                        if (!(next instanceof LdcInsnNode) || !((LdcInsnNode)next).cst.equals(0.25)) continue;
                        methodNode.instructions.insertBefore(next, this.filterEntities());
                        break block12;
                    }
                    break;
                }
            }
        }
    }

    private InsnList filterEntities() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new TypeInsnNode(193, "net/minecraft/entity/item/EntityTNTPrimed"));
        LabelNode ifne = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(154, ifne));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new TypeInsnNode(193, "net/minecraft/entity/item/EntityFallingBlock"));
        list.add((AbstractInsnNode)new JumpInsnNode(154, ifne));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new TypeInsnNode(193, "net/minecraft/entity/item/EntityItem"));
        list.add((AbstractInsnNode)new JumpInsnNode(154, ifne));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new TypeInsnNode(193, "net/minecraft/client/particle/EntityFX"));
        LabelNode ifeq = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        list.add((AbstractInsnNode)ifne);
        list.add((AbstractInsnNode)new VarInsnNode(25, 3));
        list.add((AbstractInsnNode)new InsnNode(176));
        list.add((AbstractInsnNode)ifeq);
        return list;
    }

    private InsnList getFasterSkyColor() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getPatcherConfigClass(), "disableConstantFogColorChecking", "Z"));
        LabelNode ifeq = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        list.add((AbstractInsnNode)new FieldInsnNode(178, "club/sk1er/patcher/util/world/WorldHandler", "skyColorVector", "Lnet/minecraft/util/Vec3;"));
        list.add((AbstractInsnNode)new InsnNode(176));
        list.add((AbstractInsnNode)ifeq);
        return list;
    }

    private InsnList removeTileEntities() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", "field_147483_b", "Ljava/util/List;"));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "isEmpty", "()Z", true));
        LabelNode labelNode = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(154, labelNode));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", "field_175730_i", "Ljava/util/List;"));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", "field_147483_b", "Ljava/util/List;"));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "removeAll", "(Ljava/util/Collection;)Z", true));
        list.add((AbstractInsnNode)new InsnNode(87));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", "field_147482_g", "Ljava/util/List;"));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", "field_147483_b", "Ljava/util/List;"));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "removeAll", "(Ljava/util/Collection;)Z", true));
        list.add((AbstractInsnNode)new InsnNode(87));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", "field_147483_b", "Ljava/util/List;"));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "clear", "()V", true));
        list.add((AbstractInsnNode)labelNode);
        return list;
    }

    private InsnList setLightLevel() {
        InsnList insns = new InsnList();
        insns.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/Minecraft", "func_71410_x", "()Lnet/minecraft/client/Minecraft;", false));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/client/Minecraft", "func_152345_ab", "()Z", false));
        LabelNode ifeq = new LabelNode();
        insns.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, "club/sk1er/patcher/util/world/FullbrightTicker", "isFullbright", "()Z", false));
        insns.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        insns.add((AbstractInsnNode)new IntInsnNode(16, 15));
        insns.add((AbstractInsnNode)new InsnNode(172));
        insns.add((AbstractInsnNode)ifeq);
        return insns;
    }

    private InsnList setSkyHeight() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getPatcherConfigClass(), "skyHeight", "Z"));
        LabelNode ifeq = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        list.add((AbstractInsnNode)new InsnNode(14));
        list.add((AbstractInsnNode)new InsnNode(175));
        list.add((AbstractInsnNode)ifeq);
        return list;
    }
}

